function d = MTdufng(t,v)

% The function DUFNG solves the Duffing equation:
% dX/dT=Y; dY/dT=X*(1-X^2)+R*cos(W*T)-B*Y.
% 
% The equation coefficients in the code are set as follows:
% B=0, R=0.1 and W=2*pi/25.
%
% Calling sequence-
% d=dufng(t,v)
%
% Input-
%	t	- vector of time values
%	v	- a column vector of 2 components v(2,1)
%		representing X and Y
% Output-
%	d	- a column vector of 2 components d(2,1)
%		representing dX/dT and dY/dT
 
%----- Initialize
lmta=.1;
omg=2*pi/25;
d=zeros(2,1);

%----- Solve
d(1)=v(2);
d(2)=v(1)-v(1)*v(1)*v(1)+lmta*cos(omg*t);