function outsig = create_triangle(insig,center,slopes,fs)
% creates 1 triangular spike with specified center and slope
% insig: input signal
% center: [a,b], a is the x axis and b is y axis point
% slope: scaler
% fs sampling frequency if insig
%              ^ (a,b) <-- this peak point position is (a,b)
%             / \
%            /   \   dy/dx <-- slope of the triangle
% ----------/     \--------
outsig = zeros(size(insig));
halfwidth = floor((center(2)/slopes)*fs);
dy = center(2)/halfwidth;
y = [0:dy:center(2) center(2)-dy:-dy:0];
lst = center(1) - halfwidth;
outsig( lst:(lst+length(y)-1)) = y;
% plot(y)
% plot(diff(y)*fs)
